import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viser_remit/core/utils/dimensions.dart';
import 'package:viser_remit/core/utils/my_color.dart';
import 'package:viser_remit/core/utils/my_images.dart';
import 'package:viser_remit/core/utils/my_strings.dart';
import 'package:viser_remit/core/utils/style.dart';
import 'package:viser_remit/data/services/api_client.dart';

class HeaderSectionProfile extends StatelessWidget {
  const HeaderSectionProfile({
    super.key,
  });

  @override
  Widget build(BuildContext context) {
    return Row(
      children: [
        const CircleAvatar(
          radius: 27,
          backgroundColor: MyColor.colorWhite,
          backgroundImage: AssetImage(MyImages.defaultProfileImage),
        ),
        const SizedBox(width: Dimensions.space16),
        Expanded(
          child: Column(
            mainAxisAlignment: MainAxisAlignment.center,
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              Text(Get.find<ApiClient>().getCurrencyOrUsername(isCurrency: false), maxLines: 1, overflow: TextOverflow.ellipsis, style: boldExtraLarge),
              const SizedBox(height: Dimensions.space4),
              Text(
                MyStrings.showProfile.tr,
                style: regularMediumLarge.copyWith(fontSize: 13, color: MyColor.bodyTextColor),
              )
            ],
          ),
        ),
      ],
    );
  }
}
